#########################################################################
# R-code
# File: exercise_6-5-remark.r
# Coded by Huijun Feng and slightly modified by JDG.
#
# BL model: X_{t} = b \varepsilon_{t-1}X_{t-2} + \varepsilon_{t},
# 
# where {\varepsilon_{t}} is i.i.d. with zero mean and variance \sigma^{2}.
# DIS == 1: standard normal distribution; 
# DIS == 2: Student t(8) distribution.
#
# Reference:
# Feng, H., Peng, L., and Zhu, F. (2013).
#   Interval estimation for a simple bilinear model
#   Statistics & Probability Letters, 83(10), 2152-2159.
#   DOI: 10.1016/j.spl.2013.05.037.
##########################################################################
library(emplik)
library(stats)
## To run the entire process, just run the function compare(n) for 
## some specified number of iterations n; s is the length of the 
## simulated time series.

## bootstrapFun() is only one iteration
bootstrapFun <- function(b,sigma,df0,s,BN,DIS){  # start bootstrapFun

  BUP = 500
  if(DIS==1){
    epsilon <- rnorm(s+BUP,mean=0,sd=sigma)} # s values for epsilon
  if(DIS==2){
    epsilon = rt(s+BUP,df=df0)}
    x      <- numeric(s+BUP)                      
    x[1]   <- 0
    x[2]   <- 0
  for (i in 3:(s+BUP)){
    x[i] <- b * epsilon[i-1]*x[i-2]+epsilon[i]}
   xSample <- (x[(BUP+1):(BUP+s)])

  listMatFun <- function(col){   # this function finds one b estimate
  s = length(col)  
  outOne <-  (sum(col[(3:s)-2]^2)*sum(col[3:s]^2*col[(3:s)-2]^2)-sum(col[3:s]^2)
             *sum(col[(3:s)-2]^4))/((sum(col[(3:s)-2]^2))^2-(s-2)*sum(col[(3:s)-2]^4))
#            outT<-((s-2)*sum(col[3:s]^2*col[3:s-2]^2)-sum(col[3:s]^2)*sum(col[3:s-2]^2)
#            )/((s-2)*sum(col[3:s-2]^4)-(sum(col[3:s-2]^2))^2)
#   after burn up, good.

  outTwo <- sum(col[3:s]*col[(3:s)-1]*col[(3:s)-2])/sum(col[(3:s)-2]^2)
  bH     <- outTwo/outOne # this is the b estimate for the x sample
# bH     <- min(bH,1/sigma-0.0000001)
  return(bH)
  }  # end listMatFun

  bHat   <- listMatFun(xSample) # what you need as input for part 2

##### Part 2 #####
# function to do this for each xSample (x) matrix from the list
  eFun     <- function(matIn){
     s     = length(matIn)
     eH    <- numeric(s)
     eH[1] <- 0
     eH[2] <- 0
     for (i in 3:s) eH[i] <- matIn[i]-bHat*eH[i-1]*matIn[i-2]
  return(eH[3:s])
  } # end eFun

  eHat <- eFun(xSample) # creates eHat values based on xSample

    uFun <- function(eH){
    s     = length(eH)
    eStar <- matrix(NA,s,BN)

    filleStar <- function(){
      uInt  <- sample(1:s,s,replace=TRUE)
      eStar = eH[uInt]
      return(eStar)
      } # end filleStar

    eStar     <- replicate(BN,filleStar())
    xStar     <- matrix(NA,s,BN)
    xStar[1,] <- 0
    xStar[2,] <- 0
    for (i in 3:s) xStar[i,] <- bHat*eStar[i-1,]*xStar[i-2,]+eStar[i,]
    return(xStar[3:s,])
  }  # end uFun

  bootFun <- function(){
    xStar <- uFun(eHat) # new matrix (s * BN) of xStar values
##                        now use same function from above to get BN new bStar
    bStar <- apply(xStar,2,listMatFun) # BN estimate
    return(bStar)
  }  # end bootFun

  bootOut <- bootFun()    # vector of BN values bStar 
  covFun  <- function(){  # see if initial b value falls in this interval
  aa      = c(0,0)
  if(is.na(sum(bootOut))==F && is.na(bHat)==F){
    tStar        <- bootOut - bHat
    tStarOrdered <- sort(tStar, decreasing=FALSE)
    c1 <- tStarOrdered[as.integer(BN*.025)]
    c2 <- tStarOrdered[as.integer(BN*.975)]
    c3 <- tStarOrdered[as.integer(BN*.05)]
    c4 <- tStarOrdered[as.integer(BN*.95)]
    l1 <- bHat-c2
    r1 <- bHat-c1
    l2 <- bHat-c4
    r2 <- bHat-c3
    if (b>=l2 && b<=r2) {aa[1]=1}
    if (b>=l1 && b<=r1) {aa[2]=1}
    }  # end if
   return(aa)
   } # end covFun

coverage <- covFun() # b will be the initial value 

###############################
# PELM: Profile Empirical Likelihood Method in 
#       Qin and Lawless (1994), Annals of Statistics, 22, 300-325.
x0 = xSample[3:s]
x1 = xSample[3:s-1]
x2 = xSample[3:s-2]

f  = function(sig2,b_hat){
  T1     = 2*(x0^2-exp(sig2)-b_hat^2*exp(sig2)*x2^2)*b_hat*x2^2/(1+x2^2)+(x0*x1-b_hat*exp(sig2)*x2)*x2/(1+x2^2)
  T2     = (x0^2-exp(sig2)-b_hat^2*exp(sig2)*x2^2)*(1+b_hat^2*x2^2)/(1+x2^2)
  ratio  = el.test(cbind(T1,T2),c(0,0))$`-2LLR`  # Empirical LR test for the means, uncensored data
# T1     = (x0^2-exp(sig2)-b_hat^2*exp(sig2)*x2^2)*x2^2
# T2     = (x0^2-exp(sig2)-b_hat^2*exp(sig2)*x2^2)
# T3     = (x0*x1-b_hat*exp(sig2)*x2)*x2
# ratio  = el.test(cbind(T2,T3),c(0,0))$`-2LLR`
  return(ratio)
  } # end f

ff = function(sig2,b_hat){
# T1     = 2*(x0^2-exp(sig2)-b_hat^2*exp(sig2)*x2^2)*b_hat*x2^2+(x0*x1-b_hat*exp(sig2)*x2)*x2
# T2     = (x0^2-exp(sig2)-b_hat^2*exp(sig2)*x2^2)*(1+b_hat^2*x2^2)+(x0*x1-b_hat*exp(sig2)*x2)*b_hat*x2
# ratio = el.test(cbind(T1,T2),c(0,0))$`-2LLR`
# T1     = (x0^2-exp(sig2)-b_hat^2*exp(sig2)*x2^2)*x2^2
  T2     = (x0^2-exp(sig2)-b_hat^2*exp(sig2)*x2^2)/(1+x2^2)
  T3     = (x0*x1-b_hat*exp(sig2)*x2)*x2/(1+x2^2)
  ratio  = el.test(cbind(T2,T3),c(0,0))$`-2LLR`
  return(ratio)
  } # end ff

fnew = function(sig2,b_hat){
# T1    = 2*(x0^2-exp(sig2)-b_hat^2*exp(sig2)*x2^2)*b_hat*x2^2+(x0*x1-b_hat*exp(sig2)*x2)*x2
# T2    = (x0^2-exp(sig2)-b_hat^2*exp(sig2)*x2^2)*(1+b_hat^2*x2^2)+(x0*x1-b_hat*exp(sig2)*x2)*b_hat*x2
# ratio = el.test(cbind(T1,T2),c(0,0))$`-2LLR`
  T1    = (x0^2-exp(sig2)-b_hat^2*exp(sig2)*x2^2)*x2^2/(1+x2^2)
  T2    = (x0^2-exp(sig2)-b_hat^2*exp(sig2)*x2^2)/(1+x2^2)
  T3    = (x0*x1-b_hat*exp(sig2)*x2)*x2/(1+x2^2)
  ratio = el.test(cbind(T1,T2,T3),c(0,0,0))$`-2LLR`
  return(ratio)
  } # end fnew

fnewnew=function(thetanew){
  sig2   = thetanew[1]
  b_hat  = thetanew[2]
# T1     = 2*(x0^2-exp(sig2)-b_hat^2*exp(sig2)*x2^2)*b_hat*x2^2+(x0*x1-b_hat*exp(sig2)*x2)*x2
# T2     = (x0^2-exp(sig2)-b_hat^2*exp(sig2)*x2^2)*(1+b_hat^2*x2^2)+(x0*x1-b_hat*exp(sig2)*x2)*b_hat*x2
# ratio  = el.test(cbind(T1,T2),c(0,0))$`-2LLR`
  T1     = (x0^2-exp(sig2)-b_hat^2*exp(sig2)*x2^2)*x2^2/(1+x2^2)
  T2     = (x0^2-exp(sig2)-b_hat^2*exp(sig2)*x2^2)/(1+x2^2)
  T3     = (x0*x1-b_hat*exp(sig2)*x2)*x2/(1+x2^2)
  ratio  = el.test(cbind(T1,T2,T3),c(0,0,0))$`-2LLR`
  return(ratio)
  }  # end fnewnew

if(DIS==1){
  inisig2 = log(sigma^2)
  }
if(DIS==2){
  inisig2 = log(df0/(df0-2))
  }

a    = c(0,0)
mini = 100000
for(j in 1:10){
  val = try(nlm(f,inisig2-(j-5)*0.1,b_hat=b),silent=T)
  if(length(val)>1){
    tmp  = val$minimum
  if(tmp<mini){
    mini = tmp
  }  # end if
  }  # end if
}    # end for 
a = c(as.integer(mini<=qchisq(0.9,df=1)),as.integer(mini<=qchisq(0.95,df=1)))

aa = c(0,0)
minimini = 100000
for(j in 1:10){
  val = try(nlm(ff,inisig2-(j-5)*0.1,b_hat=b),silent=T)
  if(length(val)>1){
    tmp = val$minimum
  if(tmp<minimini){
    minimini = tmp
  } # end if
  } # end if
}   # end for
aa = c(as.integer(minimini<=qchisq(0.9,df=1)),as.integer(minimini<=qchisq(0.95,df=1)))

anew  = c(0,0)
mini1 = 100000
for(j in 1:10){
  val = try(nlm(fnew,inisig2-(j-5)*0.1,b_hat=b),silent=T)
  if(length(val)>1){
    tmp = val$minimum
  if(tmp<mini1){
    mini1 = tmp
  } # end if
  } # end if
}   # end for

mini2 = 100000
for(j in 1:10){  # thetanew = {0.26, 0.22,..., -0.1}
  val = try(nlm(fnewnew,c(inisig2-(j-5)*0.1,b-(j-5)*0.04)),silent=T)
  if(length(val)>1){
    tmp = val$minimum
  if(tmp<mini2){
    mini2 = tmp
  } # end if
  } # end if
}   # end for

anew = c(as.integer(mini1-mini2<=qchisq(0.9,df=1)),as.integer(mini1-mini2<=qchisq(0.95,df=1)))

### vector to combine coverage and test -- this works!! can be indexed  as well

comparison <- c(coverage,a,aa,anew)
 print(comparison)
return(comparison)
}  # end big loop bootstrapFUN

compare <- function(b,sigma,df0,s,n,BN,DIS){   # probabilities for n iterations
  prob         <- replicate(n,bootstrapFun(b,sigma,df0,s,BN,DIS)) # this is a set of n coverage values
  coverageProb <- c(mean(prob[1,]),mean(prob[2,])) # should be close to 90%- 95%
  profileProb1 <- c(mean(prob[3,]),mean(prob[4,]))
  profileProb2 <- c(mean(prob[5,]),mean(prob[6,]))
  profileProb3 <- c(mean(prob[7,]),mean(prob[8,]))
  probVector   <- c(coverageProb,profileProb1,profileProb2,profileProb3)
  return(probVector)
  }  # end compare

set.seed(1)  # INPUTS:
b     = 0.4  # true parameter value  
sigma = 1
df0   = 10
s     = 100  # sample size
n     = 1000 # number of iterations  
BN    = 1000 
DIS   = 1
# DIS = 2

if(DIS==1){
  myname = paste("DIS = ", DIS, " N = " , s," b = ", b," sigma = ",sigma," .Rdata", sep="")
  }
if(DIS==2){
  myname = paste("DIS = ", DIS, " N = " , s," b = ", b," df = ", df0," .Rdata", sep="")
  }

# print(myname)
# save.image(file=myname)
 
res = compare(b,sigma,df0,s,n,BN,DIS)
print(res)



